
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/ds_knight.zip" ),
		
	
}
local prefabs = {
	
	
}
local start_inv = {
	-- Custom starting items
	"estus_full",
	
	
}

local fn = function(inst)

	table.insert(inst.components.eater.foodprefs, "FLASK")
	table.insert(inst.components.eater.ablefoods, "FLASK")
	
	-- choose which sounds this character will play
	inst.soundsname = "wolfgang"

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "ds_knight.tex" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(270)
	inst.components.hunger:SetMax(170)
	inst.components.sanity:SetMax(100)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1.1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	-- Movement speed (optional)
	inst.components.locomotor.walkspeed = 3
	inst.components.locomotor.runspeed = 5
	inst.components.sanity.neg_aura_mult = 1.1
	inst.components.combat.min_attack_period = 1
	inst.components.sanity.night_drain_mult = 1.1

local broadswordrecipe = Recipe( ("broadsword"), {  Ingredient("twigs", 5), Ingredient("rocks", 5), Ingredient("rope", 1)}, RECIPETABS.WAR,  {SCIENCE = 1})
      broadswordrecipe.atlas = "images/inventoryimages/broadsword.xml"	
	  
local claymorerecipe = Recipe( ("claymore"), {  Ingredient("twigs", 5), Ingredient("marble", 1), Ingredient("rope", 1)}, RECIPETABS.WAR,  {SCIENCE = 2})
      claymorerecipe.atlas = "images/inventoryimages/claymore.xml"
	  
local knightarmorrecipe = Recipe( ("knightarmor"), {  Ingredient("rocks", 8), Ingredient("rope", 3), Ingredient("marble", 2)}, RECIPETABS.WAR,  {SCIENCE = 2})
      knightarmorrecipe.atlas = "images/inventoryimages/knightarmor.xml"
	  
local knighthelmetrecipe = Recipe( ("knighthelmet"), { Ingredient("rocks", 5), Ingredient("rope", 2), Ingredient("marble", 1)}, RECIPETABS.WAR,  {SCIENCE = 2})
      knighthelmetrecipe.atlas = "images/inventoryimages/knighthelmet.xml"
	  

	  
end

return MakePlayerCharacter("ds_knight", prefabs, assets, fn, start_inv)
